// This file is responsible for collision detection

#include <windows.h>
#include <stdio.h>
#include <string.h>

#define COL_FILE_SIZE 2000

typedef struct {
	float xmin, xmax, zmin, zmax;
}BoundingBox2D;

// This function reads in a collision data file
void ReadCollisionData(char *filename, BoundingBox2D **colBoxes)
{
	char file_buffer[COL_FILE_SIZE], *data;
	FILE *infile;
	int num_boxes;

	infile = fopen(filename, "r");
	if (infile == NULL)
	{
		printf("Cannot open %s", filename);
		return;
	}
	
	fgets(file_buffer, COL_FILE_SIZE, infile);
	data = strtok(file_buffer, " ");
	num_boxes = atoi(data);

	*colBoxes = (BoundingBox2D *)malloc(sizeof(BoundingBox2D) * num_boxes);
	for (int i=0; i< num_boxes; i++)
	{
		(*colBoxes)[i].xmin = atof(strtok(NULL, " "));
		(*colBoxes)[i].xmax = atof(strtok(NULL, " "));
		(*colBoxes)[i].zmin = atof(strtok(NULL, " "));
		(*colBoxes)[i].zmax = atof(strtok(NULL, " "));
	}

	// for testing
	/*
	for (int j=0; j< num_boxes; j++)
	{
		printf ("%f ", colBoxes[j].xmin);
		printf ("%f ", colBoxes[j].xmax);
		printf ("%f ", colBoxes[j].zmin);
		printf ("%f ", colBoxes[j].zmax);
	}
	*/

	fclose(infile);
}

// This function returns true if collision is detected
bool CollisionDetected(BoundingBox2D box1, BoundingBox2D box2)
{
	if ((box1.xmin > box2.xmax) || (box2.xmin > box1.xmax))
		return (false);
	else if ((box1.zmin > box2.zmax) || (box2.zmin > box1.zmax))
		return (false);

	return true;
}